bits 64


global switch_to_runtime
switch_to_runtime:
	; get task-local storage (into rax)
	mov rdi, rsp
	and rdi, 0xffffffffff400000
	add rdi, 4194304

	; store the cpu state into this task's slot
	; since C calls this routine as a function, we only
	; need to store the state that needs to be maintained
	; across function calls according to the ABI.
	sub rdi, 64
	mov [rdi + 0], rsp
	mov [rdi + 8], rbx
	mov [rdi + 16], rbp
	mov [rdi + 24], r12
	mov [rdi + 32], r13
	mov [rdi + 40], r14
	mov [rdi + 48], r15

	sub rdi, 64
	mov rsp, [rdi + 0]
	mov rbx, [rdi + 8]
	mov rbp, [rdi + 16]
	mov r12, [rdi + 24]
	mov r13, [rdi + 32]
	mov r14, [rdi + 40]
	mov r15, [rdi + 48]

	ret


global switch_to_task
switch_to_task:
	add rdi, 4194304

	sub rdi, 128
	mov [rdi + 0], rsp
	mov [rdi + 8], rbx
	mov [rdi + 16], rbp
	mov [rdi + 24], r12
	mov [rdi + 32], r13
	mov [rdi + 40], r14
	mov [rdi + 48], r15

	add rdi, 64
	mov rsp, [rdi + 0]
	mov rbx, [rdi + 8]
	mov rbp, [rdi + 16]
	mov r12, [rdi + 24]
	mov r13, [rdi + 32]
	mov r14, [rdi + 40]
	mov r15, [rdi + 48]

	mov rax, rsi
	mov rdi, rsi

	ret
